/******************************************************************************
 *
 * Copyright (c) 1995-2004 PalmSource, Inc. All rights reserved.
 *
 * File: Category.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *	  This file defines category structures and routines.
 *
 *****************************************************************************/

#ifndef __CATEGORY_H__
#define __CATEGORY_H__

#include <PalmTypes.h>
#include <CoreTraps.h>

#include <Form.h>
#include <List.h>

// Note: although these constants are in the range of system resource IDs, the are actually
// constants passed to CategoryCreateList, CategorySelect, and CategoryFreeList which will 
// produce the desired action.  The reason the constants are in this range is to keep them 
// out of the numeric range that developers can use for resource IDs in the attempt to avoid 
// conflicts.

#define categoryHideEditCategory					10000
#define categoryDefaultEditCategoryString		10001		


typedef struct AppInfoTag {
   UInt16	renamedCategories;
	Char	categoryLabels [dmRecNumCategories] [dmCategoryLength];
	UInt8	categoryUniqIDs[dmRecNumCategories];
	UInt8	lastUniqID;	// Uniq IDs generated by the device are between
							// 0 - 127.  Those from the PC are 128 - 255.
	UInt8	padding;
} AppInfoType;

typedef AppInfoType *AppInfoPtr;


#ifdef __cplusplus
extern "C" {
#endif

extern void CategoryCreateListV10 (DmOpenRef db, ListType *lst, 
	UInt16 currentCategory, Boolean showAll)
							SYS_TRAP(sysTrapCategoryCreateListV10);

extern void CategoryCreateList (DmOpenRef db, ListType *listP, 
	UInt16 currentCategory, Boolean showAll, 
	Boolean showUneditables, UInt8 numUneditableCategories, 
	UInt32 editingStrID, Boolean resizeList)
							SYS_TRAP(sysTrapCategoryCreateList);


extern void CategoryFreeListV10 (DmOpenRef db, ListType *lst)
							SYS_TRAP(sysTrapCategoryFreeListV10);

extern void CategoryFreeList (DmOpenRef db, ListType *listP, 
	Boolean showAll, UInt32 editingStrID)
							SYS_TRAP(sysTrapCategoryFreeList);

extern UInt16 CategoryFind (DmOpenRef db, const Char *name)
							SYS_TRAP(sysTrapCategoryFind);

extern void CategoryGetName (DmOpenRef db, UInt16 index, Char *name)
							SYS_TRAP(sysTrapCategoryGetName);

extern Boolean CategoryEditV10 (DmOpenRef db, UInt16 *category)
							SYS_TRAP(sysTrapCategoryEditV10);

extern Boolean CategoryEditV20 (DmOpenRef db, UInt16 *category, 
	UInt32 titleStrID)
							SYS_TRAP(sysTrapCategoryEditV20);

extern Boolean CategoryEdit (DmOpenRef db, UInt16 *category, 
	UInt32 titleStrID, UInt8 numUneditableCategories)
							SYS_TRAP(sysTrapCategoryEdit);

extern Boolean CategorySelectV10 (DmOpenRef db, const FormType *frm, 
	UInt16 ctlID, UInt16 lstID, Boolean title, UInt16 *categoryP, 
	Char *categoryName)
							SYS_TRAP(sysTrapCategorySelectV10);

extern Boolean CategorySelect (DmOpenRef db, const FormType *frm, 
	UInt16 ctlID, UInt16 lstID,	Boolean title, UInt16 *categoryP, 
	Char *categoryName, UInt8 numUneditableCategories, UInt32 editingStrID)
							SYS_TRAP(sysTrapCategorySelect);

extern UInt16 CategoryGetNext (DmOpenRef db, UInt16 index)
							SYS_TRAP(sysTrapCategoryGetNext);

extern void CategorySetTriggerLabel (ControlType *ctl, Char *name)
							SYS_TRAP(sysTrapCategorySetTriggerLabel);

extern void CategoryTruncateName (Char *name, UInt16 maxWidth)
							SYS_TRAP(sysTrapCategoryTruncateName);

extern void CategoryInitialize (AppInfoPtr appInfoP, UInt16 localizedAppInfoStrID)
							SYS_TRAP(sysTrapCategoryInitialize);


extern void CategorySetName (DmOpenRef db, UInt16 index, const Char *nameP)
							SYS_TRAP(sysTrapCategorySetName);

#ifdef __cplusplus 
}
#endif

#endif // __CATEGORY_H__
